#modname "Nation: Cinggis Qayan"
#description "A 3-era nation mod based on the nomadic Mongol hordes. Some Turkic, Hunnic, Buryat and Xiongnu influences."
#icon "./Cinggis_qayan/icon.tga"
#version 0.3b

--created by: kennydicke
--additional spritework: Globu
--support from: Burnsaber, Globu and GoblinKing2112
--thanks to all who posted, for insights and observations
--thanks to all who played, for trying out a second-rate amateur's first go


-- ID numbers used

--weapons 885-899 -> 15

--armor 311-314 -> 4

--monsters 3931-3998 (3999 is bad)

3931-3944 troops -> 12/+1 alternate shape/+1 reserve, 3945-3959 commanders -> 14/+1 reserve, 3960-3978 heroes/multiheroes -> 6 heroes/2 multiheroes, 3979-3984 pretenders -> 3/+1 alternate shape/+4 reserve, 3985-3998 summons -> 6/+9 reserve

--nametype Vanilla only - 111, 121, 122, 144, 145

--sites 801-806 -> 6

--nations 92-94

--spell slots 17


-------- New Weapons

#newweapon 885
#name "Five Heads"
#dmg 2
#nratt 5
#att 0
#def 0
#len 0
#rcost 0
#sound 50 -- hydra
#bonus
#secondaryeffect 51 -- strong poison
#end

#newweapon 886
#name "It Appears Suddenly"
#dmg 0
#nratt 1
#att 5
#def 0
#len 3
#rcost 0
#sound 50 -- hydra
#armornegating
#bonus
#charge
#secondaryeffectalways 255 -- area fear
#end

#newweapon 887
#name "It Attacks Savagely"
#dmg 0
#nratt 2
#att 0
#def 0
#len 4
#rcost 0
#sound 25 -- growl
#armornegating
#bonus
#secondaryeffect 449 -- life drain 2
#end

#newweapon 888
#name "It's Darkness Consumes"
#damage 0
#nratt 1
#att 0
#def 0
#len 3
#rcost 0
#sound 22 -- mind blast
--magic
#armornegating
#dt_cap
#aoe 1
#bonus
#secondaryeffectalways 441 -- banish
#end

#newweapon 889
#name "It's Darkness Binds"
#dmg 0
#att 0
#def 0
#len 3
#rcost 0
#sound 18 - life drain
#armornegating
#dt_paralyze
#aoe 1
#bonus
#secondaryeffect 219 -- false fetters
#end

#newweapon 890
#name "Spring Attack"
#dmg -3
#nratt 1
#att 2
#def 0
#len 2
#rcost 0
#sound 78 -- lion
#bonus
#charge
#end

#newweapon 891
#name "The Silver Cup of Manzan"
#dmg -5
#nratt 1
#att 0
#def 0
#len 0
#rcost 0
#sound 29
#armornegating
#bonus
#nostr
#secondaryeffectalways 387 -- sleep touch
#end

#newweapon 892
#name "Death Worm Acid"
#dmg 10
#nratt 1
#att -1
#def 0
#len 0
#range 10
#ammo 5
#rcost 0
#sound 50
#bonus
#nostr
#secondaryeffect 174 -- armor destruction
#flyspr 49 6
#end

#newweapon 893
#name "Death Worm Shock"
#dmg 10
#nratt 1
#att 2
#def 0
#len 0
#range 10
#ammo 5
#rcost 0
#sound 24
#armornegating
#shock
#bonus
#nostr
#flyspr 278 11 -- too long?
#end

#newweapon 894
#name "Javelin Hail"
#dmg 15
#nratt 3
#att -2
#def 0
#len 0
#range -1 -- str
#ammo 3
#rcost 1
#sound 19
#armorpiercing
#bonus
#nostr
#flyspr 308 1
#end

#newweapon 895
#name "Sabre"
#dmg 6
#nratt 1
#att 2
#def 0
#len 2
#rcost 2
#sound 8
#end

#newweapon 896
#name "Magic Sabre"
#dmg 6
#nratt 1
#att 2
#def 0
#len 2
#rcost 3
#sound 8
#magic
#end

#newweapon 897
#name "Medium Lance"
#dmg 10
#nratt 1
#att 1
#def 0
#len 4
#ammo 1
#rcost 1
#sound 12 -- spear
#bonus
#charge
#nostr
#end

#newweapon 898
#name "Qayan Heavy Lance"
#dmg 14
#nratt 1
#att 1
#def 0
#len 3
#ammo 1
#rcost 1
#sound 12 -- spear
#bonus
#charge
#nostr
#secondaryeffectalways 453 -- harpooning
#end

#newweapon 899
#name "Lasso"
#dmg -5
#nratt 1
#att 2
#def 0
#len 6
#ammo 2
#rcost 1
#sound 87 -- vine
#bonus
#nostr
#secondaryeffect 453 -- harpooning
#end


-------- New Armor
 
#newarmor 311
#name "Qayan Buckler"
#type 4
#prot 14
#def 3
#enc 0
#rcost 1
#end

#newarmor  312
#name "Leather Scale Hauberk"
#type 5
#prot 13
#def 0
#enc 2
#rcost 7
#end

#newarmor 313
#name "Full Leather Scale"
#type 5
#prot 15
#def -1
#enc 3
#rcost 10
#end

#newarmor 314
#name "Full Leather Lamellar"
#type 5
#prot 17
#def -1
#enc 3
#rcost 12
#end


	-------- Monsters

-------- Recruits

#newmonster 3931
--copyspr 1930 -- voi axeman
#spr1 "./Cinggis_qayan/militiaGlobu.tga"
#spr2 "./Cinggis_qayan/militiaGlobu2.tga"
#name "Unaghan Boghul" -- archer, TC
#descr "Qayan 'mothers' were often responsible for defending settlements while the men were at war. These women, little more than girls, were also the primary hunters in times of war. They were quick to don armor at the first sign of enemy encroachment, and were rarely taken by surprise. An Unaghan Boghul is a Qayan serf."
#ap 13
#mapmove 2
#hp 10
#prot 0
#size 2
#str 9
#enc 3
#att 8
#def 8
#prec 10
#mr 9
#mor 10
#gcost 10
#rcost 1
#weapon "Composite Bow"
#weapon "Dagger"
#armor "Leather Scale Hauberk"
#armor "Leather Hood"
#female
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 16
#ambidextrous 2
#nametype 121
#end

#newmonster 3932
#copyspr 1930 -- voi axeman
#name "Nokud Infantry" -- peshti city guard
#descr "The Qayan infantry is no lesser a force. They are expected to perform all the same duties as the horsemen, as well as carry supplies and stay within a half a day's march of the cavalry force they accompany. They carry a variety of tools so that they could mend clothing and armor, set up camp, repair siege weapons or shoe horses. A Nokud is a Qayan free warrior-retainer."
#ap 13
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 11
#mr 9
#mor 11
#gcost 11
#rcost 1
#weapon "Axe"
#weapon "Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 22
#ambidextrous 2
#nametype 121
#end

#newmonster 3933
--copyspr 797 -- tc archer
#spr1 "./Cinggis_qayan/archerGlobu.tga"
#spr2 "./Cinggis_qayan/archerGlobu2.tga"
#name "Nokud Bowman" -- imperial archer
#descr "Qayan bowmen are afforded no more free time than the infantry. In fact, the only difference is that they carry the most powerful recurve bows. Their deadly strength, accuracy and range, coupled with the rigorous training of expected of them daily made for a very dangerous force of archers. A Nokud is a Qayan free warrior-retainer."
#ap 13
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 9
#mor 12
#gcost 13
#rcost 1
#weapon "Axe"
#weapon "Long Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 22
#ambidextrous 2
#nametype 121
#end

#newmonster 3934
#copyspr 788 -- horseman
#name "Nokud Vanguard" -- barbarian horseman
#descr "The lightest Nokud Cavalry. Being a vanguard force, they travel at the forefront of their army. They are able to avoid the detection of their enemies and can strike from the shadows. A Nokud is a Qayan free warrior-retainer."
#ap 28
#mapmove 4
#hp 10
#prot 1 -- light barding
#size 3
#ressize 2
#str 10
#enc 4
#att 10
#def 10
#prec 11
#mr 9
#mor 11
#gcost 23
#rcost 2
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Leather Scale Hauberk"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#stealthy 0
#maxage 50
#startage 22
#ambidextrous 2
#nametype 121
#end

#newmonster 3935
#copyspr 938 -- barbarian horseman
#name "Nokud Light Cavalry" -- barbarian horseman
#descr "A light Qayan mounted unit. A Nokud is a Qayan free warrior-retainer."
#ap 27
#mapmove 3
#hp 10
#prot 1 -- light barding
#size 3
#ressize 2
#str 10
#enc 4
#att 10
#def 10
#prec 11
#mr 9
#mor 11
#gcost 25
#rcost 2
#weapon "Lasso"
#weapon "Light Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 22
#ambidextrous 2
#siegebonus 2
#pillagebonus 2
#nametype 121
#end

#newmonster 3936
#copyspr 1171 -- sauromatian raider
#name "Nokud Cavalry" -- heavy barbarian horseman
#descr "A basic Qayan mounted unit. A Nokud is a Qayan free warrior-retainer."
#ap 25
#mapmove 3
#hp 12
#prot 3 -- barding
#size 3
#ressize 2
#str 10
#enc 4
#att 11
#def 10
#prec 11
#mr 9
#mor 12
#gcost 30
#rcost 4
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 22
#ambidextrous 2
#siegebonus 2
#pillagebonus 2
#nametype 121
#end

#newmonster 3937
#copyspr 450 -- horse brother
#name "Nokud Cavalry Woman" -- styag
#descr "A female Qayan mounted unit. A Nokud is a Qayan free warrior-retainer."
#ap 25
#mapmove 3
#hp 10
#prot 3 -- barding
#size 3
#ressize 2
#str 10
#enc 4
#att 10
#def 11
#prec 12
#mr 10
#mor 13
#gcost 35
#rcost 4
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#female
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 22
#ambidextrous 2
#siegebonus 2
#pillagebonus 2
#nametype 122
#end

#newmonster 3938
#copyspr 1170 -- sauromatian lancer
#name "Bahadur" -- hatamoto/samurai cavalry
#descr "A heavy Qayan mounted unit. The Qayan nobility, are generally organized into elite units of the Imperial Guard, rather than directly into the army and acted as the equivalent to knights. A Bahadur is a Qayan knight."
#ap 24
#mapmove 2
#hp 12
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 12
#enc 4
#att 12
#def 11
#prec 11
#mr 9
#mor 14
#gcost 40
#rcost 6
#weapon "Sabre"
#weapon "Qayan Heavy Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 28
#ambidextrous 2
#siegebonus 2
#pillagebonus 2
#nametype 121
#end

#newmonster 3939
#copyspr 1079 -- chariot archer
#name "Qayan Chariot" -- noble
#descr "A Qayan driven chariot with greatbow archer."
#ap 17
#mapmove 3
#hp 10
#prot 6 -- chariot + light barding
#size 4
#ressize 3
#str 1
#enc 5
#att 10
#def 10
#prec 10
#mr 9
#mor 13
#gcost 45
#rcost 26
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Long Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 30
#ambidextrous 2
#trample
#siegebonus 2
#pillagebonus 5
#secondshape 3940
#nametype 121
#okleader
#end

#newmonster 3940
#copyspr 1080 -- archerless chariot
#name "Qayan Archerless Chariot"
#descr "A Qayan driven chariot. The archer has died."
#ap 18
#mapmove 3
#hp 11
#prot 6 -- chariot + light barding
#size 4
#ressize 3
#str 11
#enc 5
#att 11
#def 11
#prec 10
#mr 9
#mor 13
#gcost 45
#rcost 26
#weapon "Sabre"
#weapon "Hoof"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 30
#ambidextrous 2
#trample
#siegebonus 2
#pillagebonus 5
#firstshape 3939 -- maybe it shouldn't return to original shape?
#nametype 121
#end

#newmonster 3941
#spr1 "./Cinggis_qayan/javelin_launcher.tga"
#spr2 "./Cinggis_qayan/javelin_launcherb.tga"
#name "Qayan Javelin Launcher"
#descr "A horsedrawn cart designed to launch a hail of javelin fire."
#ap 16
#mapmove 2
#hp 20
#prot 12 -- cart + light barding
#size 4
#ressize 3
#str 25
#enc 5
#att 8
#def 8
#prec 8
#mr 10
#mor 10
#gcost 65
#rcost 50
#weapon "Hoof"
#weapon "Javelin Hail"
#weapon "Javelin Hail"
#weapon "Javelin Hail"
#mounted
#blind
#poisonres 100
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 100
#startage 0
#heal
#ambidextrous 2
#trample
#siegebonus 10
#pillagebonus 5
#nametype 121
#end

#newmonster 3942
#copyspr 1577 -- ancestor vessel
#name "Manghit" -- ancestor vessel
#descr "These women train rigorously, worship daily and view each other as sisters. They are more attuned to magic than most other Qayans, and have considerably higher magic resistance. Manghit wield magic sabres and bows that howl with the ferocity of their ancestors."
#ap 25
#mapmove 3
#hp 12
#prot 1 -- light barding
#size 3
#ressize 2
#str 11
#enc 4
#att 13
#def 13
#prec 12
#mr 13
#mor 15
#gcost 65
#rcost 2
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Howling Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Half Helmet"
#female
#mounted
#holy
#stealthy 10
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 30
#ambidextrous 3
#siegebonus 2
#pillagebonus 2
#magicskill 8 1
#custommagic 2304 10
#custommagic 2304 10
#magicskill 8 1
#nametype 122
#end

#newmonster 3943
#copyspr 791 -- red guard
#name "Kheshig" -- malaia druzhina
#descr "A heavy Qayan mounted unit. Honored above all and entrusted with guarding sacred areas and fortifications. They are more attuned to magic than the standard Qayan, and have slightly better magic resistance. Kheshig are the imperial guard for Qayan royalty, particularly for the rulers. Their primary purpose is as a body guard for the emperors and rulers and to protect them during the day and night. They are distinct from the regular army and normally do not normally go to battle with them, instead staying back on guard duty. Kheshig wile magic sabres and bows enchanted with magic fire."
#ap 22
#mapmove 2
#hp 14
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 12
#enc 4
#att 12
#def 12
#prec 11
#mr 10
#mor 15
#gcost 50
#rcost 6
#weapon "Magic Sabre"
#weapon "Qayan Heavy Lance"
#weapon "Hoof"
#weapon "Fire Composite Bow"
#armor "Qayan Buckler"
#armor "Full Leather Lamellar"
#armor "Half Helmet"
#mounted
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 32
#ambidextrous 3
#siegebonus 2
#pillagebonus 5
#magicskill 8 3
#nametype 121
#end

#newmonster 3944
--copyspr 676 -- shade
#spr1 "./Cinggis_qayan/kut.tga"
#spr2 "./Cinggis_qayan/kut2.tga"
#name "Kut"
#descr "Erlik gives all kinds of sickness and wants sacrifices from the people. If they do not sacrifice to him, he catches the dead bodies of the people that he killed and takes them away to this lower world and then makes them his slaves. These lifeless slaves are called Kut."
#ap 12
#mapmove 3
#hp 8
#prot 0
#size 2
#ressize 1
#str 8
#enc 0
#att 9
#def 12
#prec 10
#mr 12
#mor 14
#gcost 15
#rcost 1
#weapon "Steal Strength"
#undead
#pooramphibian
#coldres 100
#poisonres 100
#stealthy 0
#startage 150
#maxage 1000
#neednoteat
#ethereal
#nametype 121
#end


-------- Commanders

#newmonster 3945
#copyspr 789 -- heavy horseman
#name "Noyan" -- horse brother
#descr "A Qayan mounted scout. Noyans are the Qayan equivalent of renowned noblemen."
#ap 28
#mapmove 4
#hp 12
#prot 1 -- light barding
#size 3
#ressize 2
#str 11
#enc 4
#att 11
#def 11
#prec 12
#mr 9
#mor 11
#gcost 23
#rcost 2
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#stealthy 0
#spy
#maxage 50
#startage 22
#ambidextrous 2
#itemslots 13446 -- std cav
#nametype 121
#poorleader
#end

#newmonster 3946
#copyspr 939 -- barbarian heavy horsemen
#name "Tarkhan" -- knyaz
#descr "A Qayan mounted captain."
#ap 24
#mapmove 3
#hp 14
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 13
#enc 4
#att 13
#def 12
#prec 11
#mr 9
#mor 13
#gcost 40
#rcost 4
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Fire Composite Bow"
#armor "Full Leather Scale"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 27
#ambidextrous 2
#siegebonus 2
#pillagebonus 2
#itemslots 13446 -- std cav
#nametype 121
#okleader
#end

#newmonster 3947
#copyspr 451 -- horse brother
#name "Khatun" -- knyaz
#descr "A female Qayan mounted captain. Khatuns often marry Khans, and those who do are considered queens."
#ap 26
#mapmove 3
#hp 13
#prot 3 -- barding
#size 3
#ressize 2
#str 12
#enc 4
#att 12
#def 13
#prec 12
#mr 10
#mor 14
#gcost 40
#rcost 4
#weapon "Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Reinforced Leather Cap"
#female
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 27
#ambidextrous 2
#siegebonus 2
#pillagebonus 2
#itemslots 13446 -- std cav
#nametype 122
#goodleader
#end

#newmonster 3948
#copyspr 930 -- khan
#name "Khan" -- khan
#descr "The high lords of the Qayan. Fearsome and commanding, they lead the forces of the Qayan against rival nations and hostile tribes."
#ap 24
#mapmove 3
#hp 16
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 12
#enc 4
#att 14
#def 14
#prec 12
#mr 10
#mor 16
#gcost 75
#rcost 6
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 4
#standard 10
#fear 0
#siegebonus 3
#pillagebonus 10
#itemslots 13446 -- std cav
#nametype 121
#expertleader
#end

#newmonster 3949
--copyspr 1188 -- soothsayer
#spr1 "./Cinggis_qayan/sorc.tga"
#spr2 "./Cinggis_qayan/sorc2.tga"
#name "Qam of Tengri"
#descr "A servant of the cult of Tengri, the sky-father. A Qam is a lesser Qayan shaman."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 12
#mor 10
#gcost 75
#rcost 1
#weapon "Axe"
#armor "Leather Scale Hauberk"
#armor "Leather Cap"
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 2
#itemslots 15494 -- std inf
#custommagic 2304 100 -- AS
#custommagic 256 10 -- A
#custommagic 2048 10 -- S
#nametype 121
#poorleader
#end

#newmonster 3950
--copyspr 1205
#spr1 "./Cinggis_qayan/odqan.tga"
#spr2 "./Cinggis_qayan/odqan2.tga"
#name "Qam of Odqan"
#descr "A servant of the cult of Odqan, the fire spirit. A minor cult that is tolerated by the Qayan god, they have high fire magic potential. Odqan's favor allows them to throw flames. A Qam is a lesser Qayan shaman."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 12
#mor 10
#gcost 80
#rcost 1
#weapon "Quarterstaff"
#weapon "Throw Flames"
#armor "Robes"
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 55
#ambidextrous 2
#itemslots 15494 -- std inf
#custommagic 128 80 -- F
#custommagic 128 40 -- F
#nametype 121
#poorleader
#end

#newmonster 3951
#copyspr 1609 -- demon priest
#name "Qam of Erlik"
#descr "A servant of the cult of Erlik, god of death. Known for their potent death magic and priestly skills, they rule the land and are feared by all. A Qam is a lesser Qayan shaman. "
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 12
#mor 10
#gcost 120
#rcost 1
#weapon "Dagger"
#armor "Robes"
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 2
#itemslots 15494 -- std inf
#magicskill 5 1
#magicskill 8 1
#custommagic 22784 100 -- ASDB
#onebattlespell "Terror"
#nametype 121
#poorleader
#okundeadleader
#end

#newmonster 3952
--copyspr 1890 -- apothecary
#spr1 "./Cinggis_qayan/manzanGlobu.tga"
#spr2 "./Cinggis_qayan/manzanGlobu2.tga"
#name "Udagan of Manzan"
#descr "A servant of the cult of Manzan Gurme Toodei, ancestress of the patron spirits of shamanism. The Udagans of Manzan rarely study water magic, but are very powerful when they do. The silver cup allows the servants to heal. An Udagan is a lesser Qayan shamaness."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 12
#mor 10
#gcost 190
#rcost 1
#weapon "Quarterstaff"
#weapon "The Silver Cup of Manzan"
#armor "Robes"
#holy
#female
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#healer 20
#ambidextrous 2
#nobadevents 5
#itemslots 15494 -- std inf
#magicskill 8 1
#custommagic 256 100 -- A
#custommagic 2048 100 -- S
#custommagic 8704 40 -- WN
#magicboost 2 1
#nametype 121
#poorleader
#end

#newmonster 3953
#copyspr 1161 -- antlered shaman
#name "Qam of Bay-Ulgen"
#descr "A servant of the cult of Bay-Ulgen, patron god of shamans, source of knowledge. Although weaker magically than the Qams of Bay-Ulgen, the servants play their part and have good magical knowledge. A Qam is a lesser Qayan shaman."
#ap 14
#mapmove 2
#hp 12
#prot 0
#size 2
#str 11
#enc 3
#att 12
#def 12
#prec 12
#mr 12
#mor 12
#gcost 210
#rcost 1
#weapon "Magic Staff"
#armor "Full Leather Lamellar"
#armor "Leather Cap"
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 2
#researchbonus 1
#douse 1
#itemslots 15494 -- std inf
#magicskill 8 1
#custommagic 26624 100 -- SN
#custommagic 26624 100 -- SN
#custommagic 16384 50 -- B
#magicboost 4 1
#magicboost 6 1
#magicboost 7 1
#nametype 121
#poorleader
#end

#newmonster 3954
#copyspr 1774 -- bean sidhe (banshee)
--spr1 "./Cinggis_qayan/sorc.tga"
--spr2 "./Cinggis_qayan/sorc2.tga"
#name "Udagan of Eje"
#descr "A servant of Gazar Eje, mother earth. The Udagans of Eje are powerful mages in their own right. An Udagan is a lesser Qayan shamaness."
#ap 12
#mapmove 2
#hp 10
#prot 0
#size 2
#str 10
#enc 3
#att 9
#def 11
#prec 12
#mr 12
#mor 12
#gcost 200
#rcost 1
#weapon "Quarterstaff"
#armor "Robes"
#female
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 2
#researchbonus -2
#nobadevents 5
#magicskill 8 2
#custommagic 9216 100 -- EN
#custommagic 9216 100 -- EN
#custommagic 2048 50 -- S
#magicboost 3 1
#magicboost 6 1
#nametype 122
#poorleader
#end

#newmonster 3955
#copyspr 1709 -- ancestor smith
#name "Qam of Ot"
#descr "A servant of the cult of Ot, queen of fire, goddess of earth. Qams of Ot tend to either become moderately powerful earth or fire mages, or split their focus into both paths. They are responsible for the creation of magical items; a fact that keeps them in the good graces of the Qayan god. A Qam is a lesser Qayan shaman."
#ap 14
#mapmove 2
#hp 12
#prot 0
#size 2
#str 12
#enc 3
#att 12
#def 12
#prec 12
#mr 12
#mor 12
#gcost 220 -- not enough
#rcost 1
#weapon "Magic Sabre"
#armor "Full Leather Lamellar"
#armor "Reinforced Leather Cap"
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 2
#forgebonus 10
#itemslots 15494 -- std inf
#custommagic 1152 100 -- FE
#custommagic 1152 100 -- FE
#magicboost 53 1
#nametype 121
#okleader
#end

#newmonster 3956
--copyspr 1181 -- enarie
#spr1 "./Cinggis_qayan/priestessGlobu.tga"
#spr2 "./Cinggis_qayan/priestessGlobu2.tga"
#name "Iduan of Tengri"
#descr "A priestess of the cult of Tengri, the sky-father. Iduans of Tengri are exceptionally powerful in their chosen path of magic. An Iduan is a powerful Qayan shamaness."
#ap 14
#mapmove 2
#hp 12
#prot 0
#size 2
#str 11
#enc 3
#att 12
#def 12
#prec 12
#mr 14
#mor 14
#gcost 280
#rcost 1
#weapon "Lightning Spear"
#armor "Full Leather Laminar"
#armor "Reinforced Leather Cap"
#female
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 38
#ambidextrous 2
#itemslots 15494 -- std inf
#magicskill 8 1
#custommagic 2304 100 -- AS
#magicboost 1 3
#magicboost 4 3
#magicboost 8 1
#nametype 122
#poorleader
#end

#newmonster 3957
#copyspr 1577 -- ancestor vessel
#name "Manghit Udagan"
#descr "The leaders of the the Manghits, they act as a spiritual cannoness for them. An Udagan is a lesser Qayan shamaness."
#ap 25
#mapmove 4
#hp 16
#prot 1 -- light barding
#size 3
#ressize 2
#str 12
#enc 3
#att 14
#def 14
#prec 12
#mr 13
#mor 15
#gcost 160
#rcost 2
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Howling Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#female
#mounted
#holy
#stealthy 10
#spy
#assassin
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 4
#siegebonus 2
#pillagebonus 2
#itemslots 13446 -- std cav
#magicskill 8 2
#custommagic 2304 10 -- AS
#custommagic 2304 10 -- AS
#custommagic 2304 10 -- AS
#nametype 122
#okleader
#end

#newmonster 3958
#copyspr 1925 -- black hood
#name "Saman of Bay-Ulgen"
#descr "A priest of the cult of Bay-Ulgen, patron god of shamans, source of knowledge. The Samans of Bay-Ulgen are rarely powerful in one path, but can often be well versed in more than one. A Saman is a powerful Qayan shaman."
#ap 24
#mapmove 3
#hp 14
#prot 3 -- barding
#size 2
#ressize 2
#str 12
#enc 4
#att 13
#def 13
#prec 12
#mr 15
#mor 14
#gcost 250
#rcost 4
#weapon "Axe"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Reinforced Leather Cap"
#mounted
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#stealthy 10
#maxage 50
#startage 38
#ambidextrous 2
#researchbonus 2
#douse 2
#itemslots 13446 -- std cav
#magicskill 8 1
#custommagic 26624 100 -- SNB
#custommagic 26624 100 -- SNB
#custommagic 26624 50 -- SNB
#magicboost 53 1
#magicboost 4 1
#magicboost 6 1
#nametype 121
#poorleader
#end

#newmonster 3959
--copyspr 1711 -- ancestor guide
#spr1 "./Cinggis_qayan/necro.tga"
#spr2 "./Cinggis_qayan/necro2.tga"
#name "Saman of Erlik"
#descr "A priest of the cult of Erlik, god of death. Known for their potent death magic and priestly skills, they rule the land and are feared by all. A Saman is a powerful Qayan shaman."
#ap 14
#mapmove 2
#hp 10
#prot 0
#size 2
#ressize 2
#str 10
#enc 3
#att 10
#def 10
#prec 12
#mr 12
#mor 10
#gcost 350
#rcost 1
#weapon "Quarterstaff"
#armor "Full Leather Lamellar"
#armor "Bone Helmet"
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 38
#ambidextrous 2
#fear 0
#itemslots 15494 -- std inf
#magicskill 5 2
#magicskill 8 1
#custommagic 22784 100 -- ASDB
#onebattlespell "Terror"
#magicboost 53 1
#nametype 121
#poorleader
#goodundeadleader
#end


-------- Heroes

-- Erlik Hero 1

#newmonster 3960
--copyspr 676 -- shade
#spr1 "./Cinggis_qayan/boogeyman.tga"
#spr2 "./Cinggis_qayan/boogeyman2.tga"
#name "Khadny Mangaa"
--descr "A Khadny Mangaa, literally 'the Rock Monster' is a horrible and evil creature made of pure of shadow. It delights in killing, especially children - and wherever it goes, people die. It travels by phasing through matter, and loves to strike at lone individuals from the shadows. As long as it is in friendly dominion, it can escape into shadow rather than be killed. It feeds on the lifeforce of the living and may bind it's enemies with shadows. It is nigh-invulnerable to physical attacks, and grows stronger in darkness. Some cultures know it as 'the Bogeyman'."

#descr "We were riding towards the capitol, when we first saw it; no more than an odd shadow on the road ahead. The shadow dissolved as we came upon it and we thought nothing of it, a mere trick by the sun. It appeared suddenly, ripping a man from his saddle, seemingly coming up from the ground itself. I could see death in his eyes as he fell. It attacked savagely, two men were felled in one swoop, all life drained from their bodies. It seemed to bring darkness with it, darkness and shadows. It's darkness consumed more men; they disappeared instantly, never to be seen again. It's darkness binded the rest of the men, strands of solid darkness held them. The creature moved so swiftly, walking through man, horse and rock as if they weren't solid. I fled, like a coward, down the road as fast as my horse could gallop. I had heard tales of the Khadny Mangaa, the rock monsters, the... bogeymen, but I never believed them; until now. - Last entry of a soldier's journal found near an empty campsite."
#ap 20
#mapmove 4
#hp 50
#prot 10
#size 2
#ressize 1
#str 15
#att 15
#def 25
#prec 12
#mr 15
#mor 20
#gcost 0
#rcost 0
#weapon "It Appears Suddenly"
#weapon "It Attacks Savagely"
#weapon "It's Darkness Consumes"
#weapon "It's Darkness Binds"
#immortal
#flying
#poisonres 100
#darkvision 100
#stealthy 50
#assassin
#startage 1000
#maxage 20000
--heal
#darkpower 5
#ambidextrous 2
#ethereal
#fear 5
#popkill 3
#itemslots 15494 -- std inf
#onebattlespell "Personal Luck"
#nametype 121
#noleader
#end

-- Erlik Hero 2

#newmonster 3961
#copyspr 1822
#name "Arvan Tavan Tolgoytoy Atgaalzhin"
#descr "The Sinful Black Monster with 15 Heads is a gigantic, frightful beast. The beast is a wasteland cousin of the swamp hydras, although it's body is vulnerable to destruction, no matter the number of heads. The Sinful Black Monster's stupidity is only matched by it's viciousness."
#ap 10
#mapmove 1
#hp 150
#prot 17
#size 1
#ressize 6
#str19
#att 15
#def 12
#prec 12
#mr 18
#mor 30
#gcost 0
#rcost 0
#weapon "Five Heads"
#weapon "Five Heads"
#weapon "Five Heads"
#eyes 30
#animal
#coldblood
#wastesurvival
#poisonres 100
#startage 53
#maxage 270
#ambidextrous 2
#fear 5
#regeneration 20
#poisoncloud 6
#noitem
#nametype 121
#noleader
#end

-- Erlik Hero 3

#newmonster 3962
#end

-- Erlik Hero 4

#newmonster 3968
#end

-- Erlik Hero 5

#newmonster 3969
#end

-- Hero 0

#newmonster 3970
#copystats 1286 -- eagle king
#copyspr 1286 -- eagle king
#name "Khangard"
#descr "The Khangard, or King Garid, is a mysterious hybrid creature. He has the head and the wings of a bird, the body of a human, and the legs of a tiger. He is believed to be the king of all birds. In the far off lands of Bandar Log and Lanka, he is called King Garuda."
#unique
#animalawe 1
#end

-- Hero 1

#newmonster 3971
--copyspr 930 -- khan
#spr1 "./Cinggis_qayan/heroGlobu.tga"
#spr2 "./Cinggis_qayan/heroGlobu2.tga"
#name "Tamerlane"
#descr "A warlord who claims descent from Genghis. He was injured in a war long ago."
#ap 24
#mapmove 3
#hp 16
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 12
#enc 3
#att 14
#def 14
#prec 12
#mr 10
#mor 16
#gcost 100
#rcost 6
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 68
#startage 38
#startaff 100
#ambidextrous 4
#standard 10
#fear 0
#siegebonus 10
#pillagebonus 10
#itemslots 13446 -- std cav
#onebattlespell "Personal Luck"
#nametype 121
#expertleader
#end

-- Hero 2

#newmonster 3972
--copyspr 930 -- khan
#spr1 "./Cinggis_qayan/heroGlobu.tga"
#spr2 "./Cinggis_qayan/heroGlobu2.tga"
#name "Attila"
#descr "A warlord from an age long past."
#ap 25
#mapmove 3
#hp 20
#prot 0
#size 3
#ressize 2
#str 14
#enc 3
#att 17
#def 17
#prec 12
#mr 10
#mor 18
#gcost 100
#rcost 6
#weapon "Magic Sabre"
#weapon "Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 47
#startage 33
#ambidextrous 5
#standard 15
#fear 2
#siegebonus 10
#pillagebonus 30
#itemslots 13446 -- std cav
#onebattlespell "Personal Luck"
#nametype 121
#superiorleader
#end

-- Hero 3

#newmonster 3973
--copyspr 930 -- khan
#spr1 "./Cinggis_qayan/heroGlobu.tga"
#spr2 "./Cinggis_qayan/heroGlobu2.tga"
#name "Subutai"
#descr "The most highly trusted advisor-general. As a commander, he has led more successful campaigns than anyone in history. He is able to fire a longbow from horseback."
#ap 25
#mapmove 3
#hp 17
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 12
#enc 3
#att 14
#def 14
#prec 12
#mr 10
#mor 16
#gcost 100 -- maybe he doesn't need a salary?
#rcost 6
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Long Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#sailing -- bridge building
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 72
#startage 38
#ambidextrous 5
#standard 15
#fear 1
#siegebonus 30
#pillagebonus 10
#spreaddom 1
#itemslots 13446 -- std cav
#onebattlespell "Personal Luck"
#nametype 121
#superiorleader
#end

--Hero 4

#newmonster 3974
--copyspr 930 -- khan
#spr1 "./Cinggis_qayan/heroGlobu.tga"
#spr2 "./Cinggis_qayan/heroGlobu2.tga"
#name "Geser"
#descr "The wisest and most benevolent khan, and first prophet of Tengri."
#ap 26
#mapmove 3
#hp 20
#prot 3 -- barding
#size 3
#ressize 2
#str 14
#enc 3
#att 17
#def 17
#prec 12
#mr 14
#mor 18
#gcost 0
#rcost 4
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#holy
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 100
#startage 38
#ambidextrous 5
#standard 15
#awe 2
#siegebonus 15
#pillagebonus 15
#spreaddom 1
#itemslots 31878 -- std cav, 3 misc
#magicskill 8 4
#onebattlespell "Personal Luck"
#nametype 121
#superiorleader
#end

--Hero 5

#newmonster 3975
#copyspr 1577 -- ancestor vessel
#name "Manghit Iduan"
#descr "The most powerful Manghit priestess of the Qayan god. She is the high cannoness and leads the devout in war. An Iduan is a powerful Qayan shamaness."
#ap 25
#mapmove 4
#hp 18
#prot 1 -- light barding
#size 3
#ressize 2
#str 12
#enc 3
#att 15
#def 15
#prec 12
#mr 13
#mor 15
#rcost 2
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Howling Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#female
#mounted
#holy
#stealthy 10
#spy
#assassin
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 60
#startage 38
#ambidextrous 4
#siegebonus 2
#pillagebonus 2
#itemslots 29830 -- std cav, 3 misc
#magicskill 1 2
#magicskill 4 2
#magicskill 8 3
#onebattlespell "Personal Luck"
#domsummon20 "Manghit"
#makemonster2 "Manghit"
#nametype 122
#goodleader
#end

--Hero 6

#newmonster 3976
--copyspr 1650 -- oreiad
#spr1 "./Cinggis_qayan/burkhan.tga"
#spr2 "./Cinggis_qayan/burkhan2.tga"
#name "Supreme Burkhan"
#descr "The most powerful of all Tenger, and the foremost of Tengri's chosen spirits. She appears only to the most noble and faithful of all the Qayan to give advice and direction, much like the angels of other faiths."
#ap 25
#mapmove 4
#hp 40
#prot 0
#size 4
#ressize 1
#str 8
#enc 0
#att 12
#def 12
#prec 12 -- too high?
#mr 18
#mor 30 -- too high?
#gcost 0
#rcost 1
#weapon 243 -- lightning
#weapon 243 -- lightning
#weapon 419 -- lightning strike
#weapon 419 -- lightning strike
#female
#holy
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 100
#maxage 10000
#startage 2400
#ambidextrous 2
#neednoteat
#stormpower 8 -- too high?
#ethereal
#trample
#siegebonus 2
#itemslots 64646 -- std inf, 4 misc
#magicskill 1 3
#magicskill 4 3
#magicskill 8 3
#magicboost 53 1
#onebattlespell "Storm" -- need the ID number, doesn't seem to work!
#makemonster2 3997
#nametype 111
#poorleader
#okmagicleader
#end

-- Multihero 1

#newmonster 3977
#copyspr 930 -- khan
#name "Qayan Khagan"
#descr "A Qayan khan great enough to be given his own empire."
#ap 24
#mapmove 3
#hp 16
#prot 5 -- heavy barding
#size 3
#ressize 2
#str 12
#enc 3
#att 14
#def 14
#prec 12
#mr 10
#mor 16
#gcost 100
#rcost 6
#weapon "Magic Sabre"
#weapon "Qayan Heavy Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 50
#startage 33
#ambidextrous 4
#standard 10
#fear 0
#siegebonus 3
#pillagebonus 15
#itemslots 13446 -- std cav
#nametype 121
#expertleader
#end

--Multihero 2

#newmonster 3978
--copyspr 569 -- air elemental, size 4
#spr1 "./Cinggis_qayan/skySpiritLarge.tga"
#spr2 "./Cinggis_qayan/skySpiritLarge2.tga"
#name "Tenger"
#descr "Powerful spirits that roam the skies."
#ap 25
#mapmove 4
#hp 15
#prot 0
#size 4
#ressize 1
#str 12
#enc 0
#att 14
#def 14
#prec 0
#mr 16
#mor 50
#gcost 0
#rcost 1
#weapon 185 -- lightning swarm
#weapon 185 -- lightning swarm
#weapon 185 -- lightning swarm
#holy
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 100
#maxage 10000
#startage 2350
#neednoteat
#ambidextrous 2
#stormpower 3
#ethereal
#trample
#siegebonus 5
#noitem -- misc only
#magicskill 1 2
#magicskill 8 1
#magicboost 53 1
#makemonster1 3997
#nametype 111
#poorleader
#poormagicleader
#end


-------- Pretenders

-------- Vanilla

#selectmonster 499 -- nataraja
#restrictedgod 94
#restrictedgod 93
#restrictedgod 92
#end

#selectmonster 1096 -- destroyer of worlds
#restrictedgod 94
#restrictedgod 93
#restrictedgod 92
#end

#selectmonster 1339 -- lord of plenty
#restrictedgod 94
#restrictedgod 93
#restrictedgod 92
#end

#selectmonster 1341 --deva
#restrictedgod 94
#restrictedgod 93
#restrictedgod 92
#end

#selectmonster 1342 -- mother of rivers
#restrictedgod 94
#restrictedgod 93
#restrictedgod 92
#end

#selectmonster 1344 -- lady of fortune
#restrictedgod 94
#restrictedgod 93
#restrictedgod 92
#end


#newmonster 3979
--copyspr 930 -- khan
#spr1 "./Cinggis_qayan/heroGlobu.tga"
#spr2 "./Cinggis_qayan/heroGlobu2.tga"
#name "Genghis"
#descr "A commander so fearsome and revered that he has become unto a god himself. Sacred Qayan warriors flock to his banner."
#ap 30
#mapmove 3
#hp 30
#prot 5 -- heavy barding
#size 3
#str 16
#enc 2
#att 18
#def 18
#prec 12
#mr 18
#mor 30
#gcost 25
#pathcost 75
#startdom 3
#weapon "Magic Sabre"
#weapon "Medium Lance"
#weapon "Hoof"
#weapon "Composite Bow"
#armor "Full Leather Lamellar"
#armor "Qayan Buckler"
#armor "Half Helmet"
#restrictedgod 94
#mounted
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 100
#startage 33
#ambidextrous 6
#standard 15
#awe 1
#fear 3
#siegebonus 20
#pillagebonus 20
#itemslots 13446 -- std cav
#magicboost 53 1
#onebattlespell "Divine Blessing"
#domsummon20 3943
#nametype 121
#superiorleader
#end

#newmonster 3981
--copyspr 567 -- air elemental, largest
#spr1 "./Cinggis_qayan/tengri.tga"
#spr2 "./Cinggis_qayan/tengri2.tga"
#name "Tengri"
#descr "The first core being in Tengriism is Sky-Father Tengri (Tenger Etseg). Ideologically, the Great Khans based their power on a mandate from Tengri; beginning their declarations with the quote 'by the will of Eternal [Blue] Heaven.' Tengri, sometimes known as Father Heaven is worshipped as the timeless and infinite blue sky. He said to have two or more sons, but was never visualized as a person."
#ap 40
#mapmove 4
#hp 30
#prot 0
#size 6
#ressize 6
#str 15
#enc 0
#att 16
#def 18
#prec 4
#mr 18
#mor 30
#gcost 200
#rcost 1
#pathcost 100
#startdom 1
#weapon 243 -- lightning
#weapon 243 -- lightning
#weapon 185 -- lightning swarm
#weapon 185 -- lightning swarm
#restrictedgod 93
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 150
#maxage 10000
#startage 2550
#neednoteat
#stormpower 4
#ambidextrous 6
#awe 1
#ethereal
#trample
#siegebonus 30
#itemslots 4096 -- one 1
#magicskill 1 1
#magicskill 4 1
#domsummon20 572 -- air elemental, smallest
#nametype 111
#poorleader
#goodmagicleader
#end

#newmonster 3983
--copyspr 1609 -- demon priest
#spr1 "./Cinggis_qayan/erlik.tga"
#spr2 "./Cinggis_qayan/erlik2.tga"
#name "Erlik"
#descr "Erlik (Erlig) is the god of death, evil and the underworld. He was the first creation of either Tengri or Ulgen, but Erlik's pride led to friction and he was banished. He was believed to have a hand in the creation of humanity, and is considered to be the first of mankind. He is often represented by a totemic bear. He slew the messenger-god, Maidere, and teaches sin to the people. Erlik is in an inferior position to Ulgen, but wants to be his equal. He once tried to create his own land, and was punished by being imprisoned at the 9th layer of the earth. While there, he became opposed to the upper world and the realm of light. Erlik's assistants are evil spirits he creates; they bring misfortune, sickness and death to all."
#ap 14
#mapmove 2
#hp 20
#prot 0
#size 2
#str 12
#enc 3
#att 14
#def 14
#prec 12
#mr 18
#mor 30
#gcost 175
#rcost 1
#pathcost 50
#startdom 1
#weapon 449 -- strong life drain
#weapon 449 -- strong life drain
#armor "Full Leather Lamellar"
#armor "Bone Helm"
#restrictedgod 92
#darkvision 100
#stealthy 10
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 30
#maxage 10000
#startage 2450
#darkpower 5
#fear 0
#itemslots 15494 -- std inf
#magicskill 5 3
#shapechange 3984 -- bear form
#domsummon2 "Kut"
#nametype 121
#poorleader
#superiorundeadleader
#end

#newmonster 3984
#copyspr 1951 -- great forest bear
#name "Erlik' Bear Form"
#descr "Erlik (Erlig) is the god of death, evil and the underworld. He was the first creation of either Tengri or Ulgen, but Erlik's pride led to friction and he was banished. He was believed to have a hand in the creation of humanity, and is considered to be the first of mankind. He is often represented by a totemic bear. He slew the messenger-god, Maidere, and teaches sin to the people. Erlik is in an inferior position to Ulgen, but wants to be his equal. He once tried to create his own land, and was punished by being imprisoned at the 9th layer of the earth. While there, he became opposed to the upper world and the realm of light. Erlik's assistants are evil spirits he creates; they bring misfortune, sickness and death to all."
#ap 25
#mapmove 3
#hp 100
#prot 10
#size 4
#str 20
#enc 3
#att 16
#def 16
#prec 12
#mr 18
#mor 30
#weapon 449 -- strong life drain
#weapon 33 -- claws
#weapon 417 -- strongest bite
#weapon 90 -- crush
#darkvision 100
#stealthy 0
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 50
#maxage 10000
#startage 2450
#darkpower 5
#fear 5
#trample
#incunrest 5
#itemslots 12288 -- 2 misc
#magicskill 5 3
#magicboost 53 -1
#shapechange 3983 -- human form
#domsummon20 "Kut"
#nametype 121
#poorleader
#superiorundeadleader
#end


-------- Summons

-- Sacred Steed of Bay-Ulgen

#newmonster 3985
#end

-- Sacred Rider of Bay-Ulgen

#newmonster 3986
#end

-- Abaasy

#newmonster 3987
--copyspr 571 -- air elemental, size 2
#spr1 "./Cinggis_qayan/evilSpirit.tga"
#spr2 "./Cinggis_qayan/evilSpirit2.tga"
#name "Abaasy"
#descr "Some of the Tengers are dark and evil by nature. Kut may technically be the weakest of all the Qayan spirits, but Abaasy are the weakest of the spirits who aren't transformed souls - weakest of the nature spirits. The evil Tengers all serve Erlik, god of death. Abassy control lightning like other Tengers, and cause disease and decay to all whom they strike."
#ap 25
#mapmove 4
#hp 10
#prot 0
#size 2
#ressize 1
#str 6
#enc 0
#att 10
#def 10
#prec 0
#mr 15
#mor 50
#gcost 0
#rcost 1
#weapon 349 -- aoe decay
#weapon 414 -- len 1 disease
#weapon 185 -- lightning swarm
#holy
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 100
#stealthy 0
#maxage 10000
#startage 2000
#neednoteat
#darkpower 1
#stormpower 1
#ambidextrous 2
#ethereal
#trample
#siegebonus 2
#noitem -- misc only
#nametype 111
#end

-- Chotgor

#newmonster 3988
--copyspr 571 -- air elemental, size 2
#spr1 "./Cinggis_qayan/evilSpiritLarge.tga"
#spr2 "./Cinggis_qayan/evilSpiritLarge2.tga"
#name "Chotgor"
#descr "Some of the Tengers are dark and evil by nature. Chotgor are the most powerful evil Tengers, and they all serve Erlik, god of death. Chotgor control lightning like other Tengers, and cause disease and decay to all whom they strike."
#ap 25
#mapmove 4
#hp 15
#prot 0
#size 4
#ressize 1
#str 10
#enc 0
#att 13
#def 13
#prec 0
#mr 15
#mor 50
#gcost 0
#rcost 1
#weapon 349 -- aoe decay
#weapon 414 -- len 1 disease
#weapon 185 -- lightning swarm
#holy
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 100
#stealthy 0
#maxage 10000
#startage 2150
#neednoteat
#darkpower 2
#stormpower 2
#ambidextrous 2
#ethereal
#trample
#siegebonus 4
#noitem -- misc only
#magicskill 1 2
#magicskill 8 1
#magicboost 53 1
#makemonster1 3987
#nametype 111
#poorleader
#poormagicleader
#nametype 111
#end

-- Siberian Tiger

#newmonster 3989
#copyspr 1140 -- tiger
#name "Amur"
#descr "Amurs, or Qayan tigers, are even larger and more ferocious than their warm jungle counterparts. They spend much of their time in the cold forests and low hills of the north. The Qayan pray to them for success in hunting, and most consider them a sacred animal."
#ap 20
#mapmove 3
#hp 23
#prot 5
#size 3
#ressize 3
#str 16
#enc 3
#att 15
#def 12
#prec 5
#mr 5
#mor 13
#gcost 0
#rcost 1
#weapon "Bite"
#weapon "Spring Attack"
#holy
#animal
#forestsurvival
#coldres 100
#stealthy 0
#startage 16
#maxage 35
#noitem
#end

-- Mastodon

#newmonster 3990
--copyspr 419 -- mammoth
#spr1 "./Cinggis_qayan/mastodonGlobu.tga"
#spr2 "./Cinggis_qayan/mastodonGlobu2.tga"
#name "Mastodon"
#descr "A mastodon is similar to elephants and mammoths, but are not closely related. Mastodons are larger than elephants but, generally, not as large as mammoths. They roam wild in the northern reaches of Qayan territory. Due to their great bulk and thick, woolly fur, mastodons are resistant to cold. The sheer size of mammoths is enough to let them trample soldiers and horses. When hurt, they become enraged and terrified and will leave the battlefield by the shortest route possible, however, they have better morale than their pachyderm counterparts. Friendly troops as well as enemies are knocked over and trampled during the rout of a mastodon.
#ap 17
#mapmove 3
#hp 68
#prot 12
#size 6
#ressize 6
#str 21
#enc 3
#att 10
#def 7
#prec 10
#mr 5
#mor 12
#gcost 110
#rcost 20
#weapon "Trunk"
#animal
#coldres 100
#startage 19
#maxage 42
#trample
#noitem
#end

-- Bay-Ulgen

#newmonster 3991
#copyspr 621 -- treelord, rootheart
#name "Bay-Ulgen"
#descr "Bay-Ulgen literally means rich and magnificent. He is thought to be without beginning or end. Birch trees, a cosmic axis between the earth and sky, and horses were sacred to him. Horse-sacrifice was part of his worship. Ulgen symbolizes goodness, welfare, abundance, plenty of food, water, etc. He created earth, heaven and all living beings; and creates land for the people, human and animal heads, and the rainbow. Regarded as the patron god of shamans, he is the source of their knowledge. Some believe Tengri created Ulgen. Erlik, who is the god of evil and darkness, is Ulgen's enemy."
#ap 2
#mapmove 0
#hp 100 -- too high?
#prot 25
#size 6
#ressize 6
#str 14
#enc 0
#att 6
#def 2
#prec 12
#mr 18
#mor 30
#rcost 1
#weapon 240 -- branch
#weapon 240 -- branch
#weapon 240 -- branch
#weapon 240 -- branch
#unique
#immobile
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 50
#maxage 10000
#startage 2500
#supplybonus 100
#ambidextrous 6
#awe 1
#researchbonus 10
#itemslots 12288 -- 2 misc
#magicskill 1 3
#magicskill 4 3
#magicskill 6 3
#onebattlespell "Mass Protection" -- needs testing to see if it works?
#nametype 145
#poorleader
#expertmagicleader
#end

-- Mother Earth

#newmonster 3992
#copyspr 1374 -- daughter of the dawn
#name "Eje"
#descr "The second core being in Tengriism is Earth Mother Eje. Literally, 'eje' or 'eej' means 'mother;" symbolically, the earth was considered a 'mother.' She was the protector of women, children and the placenta. Her symbol is the full moon and her abode is the sky. She is the sister of Ulgen and Erlik."
#ap 30
#mapmove 3
#hp 75
#prot 3
#size 5
#ressize 5
#str 20
#enc 2
#att 12
#def 14
#prec 12
#mr 18
#mor 30
#rcost 1
#weapon 243 -- lightning
#weapon 185 -- lightning swarm
#female
#unique
#flying
#forestsurvival
#mountainsurvival
#wastesurvival
#coldres 50
#maxage 10000
#startage 2450
#healer 60
#ambidextrous 2
#awe 2
#nobadevents 33
#itemslots 15494 -- std inf
#magicskill 3 3
#magicskill 4 3
#magicskill 6 3
#onebattlespell "Wind Guide" -- need the ID number, doesn't seem to work!
#nametype 122
#goodleader
#goodmagicleader
#end

-- Mongolian Death Worm

#newmonster 3993
--copyspr 814 -- fire snake
#spr1 "./Cinggis_qayan/deathWorm.tga"
#spr2 "./Cinggis_qayan/deathWorm2.tga"
#name "Olgoi-Khorkhoi"
#descr "A huge worm that inhabits cold deserts. It hibernates most of the year and must be summoned."
#ap 8
#mapmove 1
#hp 12
#prot 10
#size 2
#ressize 2
#str 12
#enc 4
#att 12
#def 8
#prec 10
#mr 14
#mor 12
#gcost 0
#rcost 1
#weapon 65 -- venomous fangs, death
#weapon "Death Worm Acid"
#weapon "Death Worm Shock"
#animal
#blind
#pooramphibian
#wastesurvival
#coldres 50
#poisonres 100
#shockres 100
#startage 30
#maxage 200
#ambidextrous 2
#fear 0
#noitem
#nametype 144
#noleader
#end

--Almas

#newmonster 3994
--copyspr 1705 -- great ape
#spr1 "./Cinggis_qayan/yeti.tga"
#spr2 "./Cinggis_qayan/yeti2.tga"
#name "Almas"
#descr "An abnormally large humanoid from the highest mountain peaks. Almases are more savage and vicious than their yeti and sasquatch cousins. They delight in throwing men, to their deaths, from the high peaks of their homeland. A female Almas is particularly frightening, as they prefer to enslave human men in order become impregnated with half-breeds."
#ap 15
#mapmove 2
#hp 25
#prot 8
#size 3
#ressize 3
#str 19
#enc 3
#att 12
#def 10
#prec 8
#mr 10
#mor 16
#gcost 0
#rcost 0
#weapon "Fist"
#weapon "Fist"
#weapon "Head Butt"
#mountainsurvival
#coldres 100
#stealthy 5
#startage 120
#maxage 550
#heal
#winterpower 3
#ambidextrous 3
#cold 4
#iceprot 4
#noitem -- misc only
#makemonster1 3994
#nametype 144
#poorleader
#end

--Shudkher

#newmonster 3995
--copyspr 1737 -- rakshasa warrior
#spr1 "./Cinggis_qayan/sholmos.tga"
#spr2 "./Cinggis_qayan/sholmos2.tga"
#name "Shudkher"
#descr "Evil humanoid demon. They increase unrest wherever they go."
#ap 12
#mapmove 2
#hp 39
#prot 10
#size 3
#ressize 3
#str 20
#enc 3
#att 14
#def 12
#prec 10
#mr 17
#mor 17
#gcost 300
#rcost 35
#weapon 363 -- iron cudgel
#armor "Furs"
--armor "Full Leather Lamellar"
#demon
#mountainsurvival
#wastesurvival
#coldres 50
--fireres 50
--poisonres 50
#darkvision 50
#startage 532
#maxage 867
#heal
#supplybonus -5
#neednoteat
#fear 0
#douse 2
#incunrest 1
#itemslots 15494 -- std inf
#custommagic 16384 70
#custommagic 4096 30
#magicboost 5 2
#magicboost 7 1
#makemonster1 3996
#nametype 140
#okleader
#okundeadleader
#end

--Sholmos

#newmonster 3996
--copyspr 1736 -- rakshasa
#spr1 "./Cinggis_qayan/sholmos.tga"
#spr2 "./Cinggis_qayan/sholmos2.tga"
#name "Sholmos"
#descr "An evil humanoid demon. They increase unrest wherever they go."
#ap 14
#mapmove 2
#hp 27
#prot 8
#size 3
#ressize 3
#str 18
#enc 3
#att 13
#def 12
#prec 9
#mr 13
#mor 14
#gcost 45
#rcost 10
#weapon "Stone Club"
#armor "Furs"
#demon
#mountainsurvival
#wastesurvival
#coldres 50
--fireres 50
--poisonres 50
#darkvision 50
#startage 199
#maxage 533
#heal
#supplybonus -3
#neednoteat
#incunrest 1
#end

--Endur

#newmonster 3997
--copyspr 571 -- air elemental, size 2
#spr1 "./Cinggis_qayan/skySpirit.tga"
#spr2 "./Cinggis_qayan/skySpirit2.tga"
#name "Endur"
#descr "The weakest of the Tengers, or sky spirits; they are powerful nonetheless."
#ap 25
#mapmove 4
#hp 10
#prot 0
#size 2
#ressize 1
#str 8
#enc 0
#att 12
#def 12
#prec 8
#mr 15
#mor 50
#gcost 0
#rcost 0
#weapon 419 -- lightning strike
#weapon 185 -- lightning swarm
#weapon 185 -- lightning swarm
#holy
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 100
#maxage 10000
#startage 2000
#neednoteat
#stormpower 1
#ambidextrous 2
#ethereal
#trample
#siegebonus 2
#noitem -- misc only
#nametype 111
#end

--Burkhan

#newmonster 3998
--copyspr 1650 -- oreiad
#spr1 "./Cinggis_qayan/burkhan.tga"
#spr2 "./Cinggis_qayan/burkhan2.tga"
#name "Burkhan"
#descr "Burkhan are the most powerful of the Tengers, or sky spirits. They take on a more humanoid form and appear to the most noble and pious of the Qayan to give advice and counsel, much like the angels of other faiths."
#ap 25
#mapmove 4
#hp 30
#prot 0
#size 4
#ressize 1
#str 8
#enc 0
#att 12
#def 12
#prec 12
#mr 18
#mor 30
#gcost 0
#rcost 0
#weapon 419 -- lightning strike
#weapon 243 -- lightning
#weapon 243 -- lightning
#female
#holy
#magicbeing
#immortal
#blind
#flying
#coldres 50
#poisonres 100
#shockres 100
#maxage 10000
#startage 2300
#neednoteat
#stormpower 3
#ambidextrous 2
#ethereal
#trample
#siegebonus 2
#itemslots 15494 -- std inf
#magicskill 1 3
#magicskill 4 2
#magicskill 8 2
#magicboost 53 1
#nametype 111
#poorleader
#okmagicleader
#end



-------- Spells

#selectspell "Call Ancestor"
#restricted 94
#restricted 93
#end

#selectspell "Wrath of the Ancestors"
#restricted 94
#restricted 93
#end

#newspell
#name "Summon Chotgor"
#descr "Summons a Chotgor sky spirit from the higher atmosphere."
#school 0
#researchlevel 7
#path 0 5
#path 1 1
#pathlevel 0 3
#pathlevel 1 2
#damage 3988
#effect 10021
#fatiguecost 2500
#nreff 1
#restricted 92
#end

#newspell
#name "Summon Abaasy"
#descr "Summons several Abaasy sky spirits from the higher atmosphere. A more powerful caster can summon more spirits."
#school 0
#researchlevel 5
#path 0 5
#path 1 1
#pathlevel 0 3
#pathlevel 1 1
#damage 3987
#effect 10001
#fatiguecost 1500
#nreff 1002
#restricted 92
#end

#newspell
#name "Capture Amurs"
#descr "The mage sends a group of Qayan warriors out to capture several Amur, sacred Qayan tigers."
#school 0
#researchlevel 3
#path 0 6
#pathlevel 0 3
#damage 3989
#effect 10001
#fatiguecost 1500
#nreff 1004
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Call of the Mastodon" -- gotta love mastodon!
#descr "The mage releases the call of the mastodon, and several will beckon to trample his foes in battle."
#school 0
#researchlevel 4
#path 0 6
#pathlevel 0 3
#damage 3990
#effect 43
#fatiguecost 200
#nreff 3
#range 5030
#precision 6
#sound 48
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Summon Death Worms"
#descr "Summons death worms from their hibernation under the desert. A more powerful caster may summon more worms."
#school 6
#researchlevel 3
#path 0 7
#pathlevel 0 2
#damage 3993
#effect 10001
#fatiguecost 1000
#nreff 1001
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Almas Commander"
#descr "Comapnion to Summon Almas."
#school -1
#researchlevel 0
#path 0 1
#path 1 6
#pathlevel 0 1
#pathlevel 1 1
#damage 3994
#effect 10021
#nreff 1
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Summon Almases"
#descr "Summons almases, yeti-like creatures, from their abode high up in the world's tallest peaks. A more powerful caster can summon more almases."
#school 0
#researchlevel 4
#path 0 1
#path 1 6
#pathlevel 0 1
#pathlevel 1 2
#damage 3994
#effect 10001
#fatiguecost 800
#nextspell "Almas Commander"
#nreff 1005
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Summon Shudkher"
#descr "Companion to Summon Sholmoses."
#school -1
#researchlevel 0
#path 0 7
#pathlevel 0 1
#damage 3995
#effect 10021
#nreff 1
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Summon Sholmoses"
#descr "Summons several Sholmoses and a Shudkher from the demonic regions. A more powerful caster can summon more demons."
#school 6
#researchlevel 4
#path 0 7
#pathlevel 0 2
#damage 3996
#effect 10001
#fatiguecost 2500
#nextspell "Summon Shudkher"
#nreff 1004
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Summon Endur"
#descr "Summons several Endur sky spirits from the higher atmosphere. A more powerful caster can summon more spirits."
#school 0
#researchlevel 6
#path 0 1
#pathlevel 0 3
#damage 3997
#effect 10001
#fatiguecost 1500
#nreff 1003
#restricted 94
#restricted 93
#end

#newspell
#name "Summon Burkhan"
#descr "Summons a Burkhan, the most powerful of sky spirits. They are air mages, and priestesses."
#school 0
#researchlevel 7
#path 0 1
#path 1 4
#pathlevel 0 4
#pathlevel 1 2
#damage 3998
#effect 10021
#fatiguecost 5500
#nreff 1
#restricted 94
#restricted 93
#end

#newspell 
#name "Call to Mother Earth"
#descr "Calls Eje, mother earth, to your aid. She is a powerful nature, earth and astral mage."
#school 0
#researchlevel 7
#path 0 6
#path 1 3
#pathlevel 0 4
#pathlevel 1 2
#damage 3992
#effect 10021
#fatiguecost 7000
#nreff 1
#restricted 94
#restricted 93
#end

#newspell
#name "Awaken Lord of the Upper Spirits"
#descr "Awaken Bay-Ulgen from his timeless sleep as a birch tree. He is a powerful nature, air and astral mage."
#school 0
#researchlevel 8
#path 0 6
#path 1 4
#pathlevel 0 4
#pathlevel 1 2
#damage 3991
#effect 10021
#fatiguecost 7000
#nreff 1
#restricted 94
#restricted 93
#end

#newspell
#copyspell "Wolven Winter"
#name "Jadaci of Snows"
#descr "The Qayan mage uses the power of a personal charm, rain stones, to ritually create and send a powerful snowstorm to a distant land, prior to invasion."
#path 0 1
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#copyspell "Rain"
#name "Jadaci of Rains"
#descr "The Qayan mage uses the power of a personal charm, rain stones, to create a powerful rainstorm during a battle."
#path 0 1
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#copyspell "Thunder Strike"
#name "Jadaci of Storms"
#descr "The Qayan mage uses the power of a personal charm, rain stones, to cause five powerful lightning bolts to strike the battlefield."
#researchlevel 6
#path 0 1
#pathlevel 0 3
#fatiguecost 100
#nreff 5
#restricted 94
#restricted 93
#restricted 92
#end

#newspell
#name "Kharash"
#descr "A commonly used Qayan tactic is the use of what is called the 'kharash'. During a siege, the Qayan gather a crowd of local residents or soldiers surrendered from previous battles, and drive them forward in sieges and battles. These 'alive boards' or 'human shields' often take the brunt of enemy arrows and crossbow bolts, thus leaving the Qayan warriors safer. The kharash are also often forced ahead to breach walls."
#school 0
#researchlevel 4
#path 0 6
#pathlevel 0 3
#damage 30
#effect 1
#fatiguecost 300
#nreff 25
#range 5010
#prec 2
#restricted 94
#end


-------- Sites

#newsite 801
#name "The Ceremonies of Ot"
#path 3
#level 0
#rarity 5
#loc 16384
#gems 0 1
#gems 3 1
#homemon 3942 -- Manghit
#end

#newsite 802
#name "Erlik's Death-Hall"
#path 5
#level 0
#rarity 5
#loc 16384
#gems 5 3
#gems 1 1
--gems 4 1
#homecom 3995 -- shudkher
#homemon 3996 -- sholmos
#end

#newsite 803
#name "The Peak of Tengri"
#path 1
#level 0
#rarity 5
#loc 16384
#gems 1 2 -- air, 2 gems
#homemon 3943 -- Kheshig
#end

#newsite 804
#name "The Grove of Bay-Ulgen"
#path 4
#level 0
#rarity 5
#loc 16384
#gems 6 1 -- nature, 1 gem
#homecom 3958 -- Saman of Bay-Ulgen
#end

#newsite 805
#name "The Lake of Manzan Gurme Toodei"
#path 4
#level 0
#rarity 5
#loc 16384
#gems 4 1 -- astral, 1 gem
#homemon 3942 -- Manghit
#end

#newsite 806
#name "The Magnificent Peak of Tengri"
#path 1
#level 0
#rarity 5
#loc 16384
#gems 1 3 -- air, 5 gems
#gems 4 1 -- astral, 1 gem
#homecom 3956 -- Iduan of Tengri
#homemon 3942 -- manghit
#homemon 3943 -- Kheshig
#end






-------- Nation

#selectnation 94
#clearnation
#name "Cinggis Qayan"
#epithet "Wrath of the Khans"
#era 2
#descr "The Chinggis Qayan are dominated by the fearsome Khans. Their homelands are not far from the capital of T'ien Ch'i, and the hordes are constantly waiting for the time to come when a new god will lead them to conquest over their old foes. The Qayan bows are among the strongest ever made and are known for their range, power and accuracy. Qayan armors and shields are of lightweight, lacquered leather scale with some iron. Silk underclothing is worn underneath for protection from arrows. They sacrifice horses to their god."
#summary "Race: Human. Military: Massed cavalry archers, chariots, siege bonus. Magic: All but fire, mostly Air and Astral. Priests: Weak to average, numerous, may sacrifice slaves."
#brief "The Chinggis Qayan are a race of nomadic horsemen roaming wasted steppe areas, descended from ancient sauromatia. They are skilled in sieging castles and extorting money from peasants. They worship the sky and the stars. Women have equal standing to men, but are not dominant as in ages past. The Qayan feel equally at home in wastes, mountains and forests."
#color 0.99 0.68 0.09
#flag "./Cinggis_qayan/flag.tga"
#templepic 18


-------- Starting Units

#startcom 3946
#startscout 3945
#startunittype1 3932
#startunitnbrs1 10 -- was 20, may be too many?
#startunittype2 3935 -- was 3932, probably shouldn't start with stealth troops?
#startunitnbrs2 10


------- Recruitable troops

#addrecunit "Nokud Infantry"
#addrecunit "Nokud Bowman"
#addrecunit "Nokud Vanguard"
#addrecunit "Nokud Light Cavalry"
#addrecunit "Nokud Cavalry"
#addrecunit "Nokud Cavalry Woman"
#addrecunit "Bahadur"
#addrecunit "Qayan Chariot"
#addrecunit "Qayan Javelin Launcher"
--addrecunit "Kheshig"

--addrecunit "Unaghan Boghul" -- test
--addrecunit "Manghit" -- test
--addrecunit "Olgoi-Khorkhoi" -- test
--addrecunit "Almas" -- test
--addrecunit "Sholmos" -- test
--addrecunit "Endur" -- test


------- Recruitable commanders

#addreccom "Noyan"
#addreccom "Tarkhan"
#addreccom "Khatun"
#addreccom "Khan"
#addreccom "Manghit Udagan"
#addreccom "Qam of Tengri"
--addreccom "Qam of Odqan"
--addreccom "Saman of Erlik"
#addreccom "Udagan of Manzan"
#addreccom "Qam of Bay-Ulgen"
#addreccom "Udagan of Eje"

--addreccom "Qam of Ot"
--addreccom "Iduan of Tengri"
--addreccom "Saman of Bay-Ulgen"
--addreccom "Almas" --test
--addreccom "Shudkher" --test
--addreccom "Burkhan" --test
--addrecunit "Amur" --test


------- Heroes

--hero1 3971 -- tamerlane
--hero2 3972 -- attila
#hero3 3973 -- subutai
#hero4 3974 -- geser
#hero5 3975 -- Iduan
#hero6 3976 -- supreme Burkhan
#multihero1 3977 -- qayan khagan
#multihero2 3978 -- Tenger


------- PD

#defcom1 "Tarkhan"
#defcom2 "Qam of Bay-Ulgen"
#defunit1 "Nokud Infantry"
#defunit1b "Unaghan Boghul"
#defunit2 "Kheshig"
#defunit2b "Nokud Light Cavalry"
#defmult1 10
#defmult1b 20
#defmult2 10
#defmult2b 10


------- Sites and Dominion

#clearsites
#startsite "The Peak of Tengri"
#startsite "The Lake of Manzan Gurme Toodei"
#startsite "The Grove of Bay-Ulgen"
#sacrificedom
#idealcold 1
#horsereanim


-------- Forts

#startfort 3 -- fortified city
#defaultfort 32 -- ramparts
#mountainfort 1 -- simple hillfort
#swampfort 11 -- swamp fort
#forestfort  33 --forest ramparts

#end




-------- Nation

#selectnation 93
--clearnation
#name "Tengri Qayan"
#epithet "Spirits of the Sky"
#era 3
#descr "The Qayan of the late age are ruled by a timeless god of the sky; his dominion is dying after bring abandoned by the khans. Their homelands are not far from the capital of T'ien Ch'i, and the hordes are constantly waiting for the time to come when a new god will lead them to conquest over their old foes. The Qayan bows are among the strongest ever made and are known for their range, power and accuracy. Qayan armors and shields are of lightweight, lacquered leather scale with some iron. Silk underclothing is worn underneath for protection from arrows. They sacrifice horses to their god."
#summary "Race: Human. Military: Massed cavalry archers, chariots, siege bonus. Magic: Mostly Air and Astral, some nature, earth and blood. Priests: Weak to average, may sacrifice slaves."
#brief "The Chinggis Qayan are a race of nomadic horsemen roaming wasted steppe areas, descended from ancient sauromatia. They are skilled in sieging castles and extorting money from peasants. They worship the sky and the stars. Women have equal standing to men, but are not dominant as in ages past. The Qayan feel equally at home in wastes, mountains and forests."
#color 0.99 0.68 0.09
#flag "./Cinggis_qayan/flag.tga"
#templepic 13


-------- Starting Units

#startcom 3946
#startscout 3945
#startunittype1 3932
#startunitnbrs1 10 -- was 20, may be too many?
#startunittype2 3935 -- was 3932, probably shouldn't start with stealth troops?
#startunitnbrs2 10


------- Recruitable troops

#addrecunit "Nokud Infantry"
#addrecunit "Nokud Bowman"
#addrecunit "Nokud Vanguard"
#addrecunit "Nokud Light Cavalry"
#addrecunit "Nokud Cavalry"
#addrecunit "Nokud Cavalry Woman"
#addrecunit "Bahadur"
--addrecunit "Qayan Chariot"
#addrecunit "Qayan Javelin Launcher"
--addrecunit "Kheshig"

--addrecunit "Manghit"
--addrecunit "Olgoi-Khorkhoi" -- test
--addrecunit "Almas" -- test
--addrecunit "Sholmos" -- test
--addrecunit "Endur" --test


------- Recruitable commanders

#addreccom "Noyan"
#addreccom "Tarkhan"
#addreccom "Khatun"
--addreccom "Khan"
#addreccom "Manghit Udagan"
#addreccom "Qam of Tengri"
--addreccom "Qam of Odqan"
--addreccom "Saman of Erlik"
--addreccom "Udagan of Manzan"
#addreccom "Qam of Bay-Ulgen"
#addreccom "Udagan of Eje"

--addreccom "Qam of Ot"
--addreccom "Iduan of Tengri"
--addreccom "Saman of Bay-Ulgen"
--addreccom "Almas" --test
--addreccom "Shudkher" --test
--addreccom "Burkhan" --test


------- Heroes

#hero1 3971 -- tamerlane
#hero2 3970 -- khangard
#hero3 3973 -- subutai
#hero4 3974 -- geser
#hero5 3975 -- manghit iduan
#hero6 3976 - supreme burkhan
#multihero1 3977 -- qayan khagan
#multihero2 3978 -- tenger


------- PD

#defcom1 "Tarkhan"
#defcom2 "Qam of Tengri"
#defunit1 "Nokud Infantry"
#defunit1b "Unaghan Boghul"
#defunit2 "Kheshig"
#defunit2b "Nokud Light Cavalry"
#defmult1 10
#defmult1b 15
#defmult2 5
#defmult2b 10


------- Sites and Dominion

#clearsites
#startsite "The Magnificent Peak of Tengri"
#dyingdom
#sacrificedom
#idealcold 1
#horsereanim


-------- Forts

#startfort 3 -- fortified city
#defaultfort 32 -- ramparts
#mountainfort 1 -- simple hillfort
#swampfort 11 -- swamp fort
#forestfort  33 --forest ramparts

#end




-------- Nation

#selectnation 92
--clearnation
#name "Erlik Qayan"
#epithet "Death & Fire"
#era 1
#descr "The Qayan of the early age are ruled by a terrible death-god. The lands are cursed and undead are easily disturbed. People die young from terrible sickness. Their homelands are not far from the capital of T'ien Ch'i, and the hordes are constantly waiting for the time to come when a new god will lead them to conquest over their old foes. The Qayan bows are among the strongest ever made and are known for their range, power and accuracy. Qayan armors and shields are of lightweight, lacquered leather scale with some iron. Silk underclothing is worn underneath for protection from arrows. They sacrifice horses to their god."
#summary "Race: Human, undead. Military: Massed cavalry archers, massed undead, chariots, siege bonus. Magic: Mostly death and fire, some astral, earth and blood. Priests: Average, no preach, may sacrifice slaves, lead and reanimate undead. Prefer one cold scale."
#brief "The Qayan are a race of nomadic horsemen roaming wasted steppe areas, descended from ancient sauromatia. They are skilled in sieging castles and extorting money from peasants. The early Qayan worshipped death and fire. Women have equal standing to men, but are not dominant as in ages past. The Qayan feel equally at home in wastes, mountains and forests."
#color 0.99 0.68 0.09
#flag "./Cinggis_qayan/flag.tga"
#templepic 7


-------- Starting Units

#startcom 3946
#startscout 3945
#startunittype1 3932
#startunitnbrs1 10
#startunittype2 3935
#startunitnbrs2 10


------- Recruitable troops

#addrecunit "Nokud Infantry"
#addrecunit "Nokud Bowman"
--addrecunit "Nokud Vanguard"
#addrecunit "Nokud Light Cavalry"
#addrecunit "Nokud Cavalry"
#addrecunit "Nokud Cavalry Woman"
#addrecunit "Bahadur"
#addrecunit "Qayan Chariot"
--addrecunit "Qayan Javelin Launcher"
--addrecunit "Kheshig"
#addrecunit "Kut"

--addrecunit "Manghit"
--addrecunit "Olgoi-Khorkhoi" -- test
--addrecunit "Almas" -- test
--addrecunit "Sholmos" -- test
--addrecunit "Endur" --test
--addrecunit "Tenger" -- test
--addrecunit "Abaasy" -- test
--addrecunit "Chotgor" -- test


------- Recruitable commanders

#addreccom "Noyan"
#addreccom "Tarkhan"
#addreccom "Khatun"
--addreccom "Khan"
--addreccom "Manghit Udagan"
--addreccom "Qam of Tengri"
#addreccom "Qam of Odqan"
#addreccom "Qam of Erlik"
#addreccom "Qam of Ot"
#addreccom "Saman of Erlik"
--addreccom "Udagan of Manzan"
--addreccom "Qam of Bay-Ulgen"
--addreccom "Udagan of Eje"

--addreccom "Iduan of Tengri"
--addreccom "Saman of Bay-Ulgen"
--addreccom "Almas" --test
--addreccom "Shudkher" --test
--addreccom "Burkhan" --test
--addreccom "Khadny Mangaa" -- test
--addreccom "Arvan Tavan Tolgoytoy Atgaalzhin" -- test


------- Heroes

#hero1 3960 -- khadny mangaa
#hero2 3972 -- attila
#hero3 3961 -- Arvan Tavan Tolgoytoy Atgaalzhin
--hero4 3974 -- geser
--hero5 3975 -- Iduan
--hero6 3976 - supreme Burkhan
#multihero1 3995 -- shudkher
#multihero2 3988 -- chotgor


------- PD

#defcom1 "Tarkhan"
#defcom2 "Qam of Erlik"
#defunit1 "Nokud Infantry"
#defunit1b "Unaghan Boghul"
#defunit2 "Kut"
#defunit2b "Sholmos"
#defmult1 10
#defmult1b 15
#defmult2 10
#defmult2b 5


------- Sites and Dominion

#clearsites
#startsite "The Ceremonies of Ot"
#startsite "Erlik's Death-Hall"
#nopreach
#sacrificedom
#idealcold 1
--domkill 1
--domunrest 1
#zombiereanim
#horsereanim


-------- Forts

#startfort 3 -- fortified city
#defaultfort 32 -- ramparts
#mountainfort 1 -- simple hillfort
#swampfort 11 -- swamp fort
#forestfort  33 --forest ramparts

#end